//  2011 IDesign Inc.
// Pytania? Komentarze? Odwied
// http://www.idesign.net

using System;
using System.ServiceModel;
using System.Windows.Forms;

namespace ServiceModelEx
{
   [ServiceContract]
   interface IActivationMonitor
   {
      [OperationContract]
      void ActivateApplication();
   }
   class ActivationMonitorService : IActivationMonitor 
   {
      public void ActivateApplication()
      {
         Form form = SingletonApp.MainForm;
         if(form != null)
         {
            if(!form.IsDisposed)
            {
               // Ten kod jest wykonywany w wtku pochodzcym z puli wtkw.
               // Do opakowania waciwoci WindowState naley uy metody anonimowej.
               if(form.WindowState == FormWindowState.Minimized)
               {
                  Action restore = delegate()
                                   {
                                      form.WindowState = FormWindowState.Normal;
                                   };
                  form.Invoke(restore,new object[]{});
               }
               Action activate = form.Activate;
               form.Invoke(activate,new object[]{});
            }
         } 
      }
   }
}
